--   timer   Tasks
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="dog";
        width=1;
        height=1;
        speed=1200;
        group=1;
        timerTask=-1;
        retreat=false;
        GridData = { 1 };
        enabled = 0;        -- do not change this parameter(  )
    };
    Objects = {};
    -- list of all tasks for an object
    Tasks = { 
        moving_dog_point = { FuncName="MovingToPointExecute", timer = {1}, hand_add=1 };
        evil_wolf   = { FuncName="EvilWolf",  timer = 4 }; 
        evil_wolf1   = { FuncName="EvilWolf1",  timer = 4 }; 
        evil_crow   = { FuncName="EvilCrow",  timer = 4 }; 
        evil_crow1   = { FuncName="EvilCrow1",  timer = 4 }; 
    };
    -- list of all triggers for an object
    Triggers = {
        RelaxKreslo = { FuncName="UpdateMovingTriger", NotRunWhen={"evil_wolf","evil_wolf1","evil_crow","evil_crow1"} };        
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {}; 
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
};
function GameObject:Get()
    return self;
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function MovingToPointExecute()
        aObject = GameObject:Get();
        
        if( not aObject.Params.iRelaxTime )then
            aObject.Params.iRelaxTime = GetRandomValue(aObject.Tasks.moving_dog_point.timer);
            CPP_SetAnimState("barn");
            CPP_PlaySound("dog_bark", 1);
        end
        
        if( aObject.Params.iRelaxTime == 0)then
            --CPP_SetAnimState("down_siting");
             aObject.Params.iRelaxTime=nil;
             CPP_StopSound("dog_bark");
            return 0;
        end
        
        aObject.Params.iRelaxTime = aObject.Params.iRelaxTime-1;
    return 1;

end


function UpdateMovingTriger()
    aObject = GameObject:Get();
    if (aObject.Params.iRelaxTime ~= nil) then
        if (aObject.Params.iRelaxTime > 0) then
            aObject.Params.iRelaxTime = aObject.Params.iRelaxTime - 1;
            return 0;
        end
    end
    CPP_OnTrigger("moving",1); --        
    --ScriptDump("UpdateMovingTriger()");
    return 0;
end

-- perform Task MILKING  over external object and return true if task is completed
function EvilWolf()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SetAnimState("up_siting");
        CPP_SetAnimState("barn");
        CPP_PlaySound("dog_bark", 1);
        tTask = aObject.Tasks.evil_wolf.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
--    if (tTask == 5) then CPP_SecondObjAnimState("1_milking_cow"); end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        aObject.Params.iRelaxTime = 5;
        --  ,   
        CPP_RecursiveRun("away_wolf",0);
        CPP_StopSound("dog_bark");        
        return 0;
    end
    return 1;
end

-- perform Task MILKING  over external object and return true if task is completed
function EvilWolf1()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SetAnimState("up_siting");
        CPP_SetAnimState("barn");
        CPP_PlaySound("dog_bark", 1);
        tTask = aObject.Tasks.evil_wolf1.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
--    if (tTask == 5) then CPP_SecondObjAnimState("1_milking_cow"); end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        aObject.Params.iRelaxTime = 5;
        --  ,   
        CPP_RecursiveRun("away_wolf",0);
        CPP_StopSound("dog_bark");        
        return 0;
    end
    return 1;
end

function EvilCrow()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SetAnimState("up_siting");
        CPP_SetAnimState("barn");
        CPP_PlaySound("dog_bark", 1);
        tTask = aObject.Tasks.evil_crow.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        aObject.Params.iRelaxTime = 5;
        --  ,   
        CPP_RecursiveRun("away_crow",0);
        CPP_StopSound("dog_bark");                
        return 0;
    end
    return 1;
end

function EvilCrow1()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SetAnimState("up_siting");
        CPP_SetAnimState("barn");
        CPP_PlaySound("dog_bark", 1);
        tTask = aObject.Tasks.evil_crow1.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        aObject.Params.iRelaxTime = 5;
        CPP_StopSound("dog_bark");                
        --  ,   
        CPP_RecursiveRun("away_crow",0);
        return 0;
    end
    return 1;
end

--     
function RestoreAfterTrashIfAsObj()
end
